#include <coleco.h>
#include <getput1.h>

#define true	0xff
#define false	0x00

char GAME_NAME[]="NOT ONE";
char GAME_AUTHOR[]="ROBERT PUOPOLO & DANIEL BIENVENU";
char GAME_YEAR[]="1975-2004";

unsigned score[2];
byte player_no;
byte game_option;
byte first_sum;
byte actual_sum;
byte nbr_tries;
byte nbr_rounds;

byte nbr_times[]={0,0,19,13,6,5,4,3,4,5,6,13,19};

byte ask_ai(void)
{
 if (nbr_tries<nbr_times[first_sum])
 { return true; }
 return false;
}

byte ask_player(void)
{
 byte *joystick;
 if (player_no==0)
 { joystick=&joypad_1; }
 else
 { joystick=&joypad_2; }
 enable_nmi();
 while((*joystick)&(FIRE1|FIRE2));
 while(((*joystick)&(FIRE1|FIRE2))==0);
 disable_nmi();
 if ((*joystick)&FIRE1)
 { return true; }
 return false;
}

byte ask_roll_again(void)
{
 if (game_option==1 && player_no==1)
 { return ask_ai(); }
 else
 { return ask_player(); }
}

byte dice(void)
{
 return rnd_byte(1,6);
}

void print_dice(byte x, byte y, byte value)
{
 put_char(x,y,0x7f+value);
}

void show_dice(byte dice_no,byte value)
{
 byte x = (dice_no<<2)+7;
 byte y = 2 + nbr_tries;
 print_dice(x,y,value);
}

void show_sum()
{
 byte sum;
 byte y = 2 + nbr_tries;
 if (y>22) y=22;
 if (nbr_tries!=0)
 { sum=actual_sum; }
 else
 { sum=first_sum; }
 print_at(19,y,str(sum)+3);
}

void roll_dices(byte *sum)
{
 byte value;
 value = dice();
 show_dice(1,value);
 *sum = value;
 value = dice();
 show_dice(2,value);
 *sum += value;
 show_sum();
}

void first_roll(void)
{
 roll_dices(&first_sum);
}

void new_roll(void)
{
 roll_dices(&actual_sum);
}

void whoisplaying(void)
{
 if (player_no==0)
 { center_string(0,"PLAYER#1"); }
 else
 {
  if (game_option==1)
  { center_string(0," COLECO "); }
  else
  { center_string(0,"PLAYER#2"); }
 }
}

void print_score(void)
{
 print_at(1,1,str(score[0]));
 print_at(26,1,str(score[1]));
}

void game_screen(void)
{
 cls();
 whoisplaying();
 print_score();
}

void game_loop(void)
{
 byte round;
 unsigned sum;
 for (round=0;round<10;round++)
 {
  for (player_no=0;player_no<2;player_no++)
  {
   nbr_tries=0;
   game_screen();
   first_roll();
   sum = first_sum;
retry:
   nbr_tries++;
   new_roll();
   sum += actual_sum;
   if (actual_sum!=first_sum)
   { if (ask_roll_again()) goto retry; }
   if (actual_sum==first_sum) sum=0;
   score[player_no] += sum;
   pause();
  }
 }
}

void init_game(void)
{
 score[0]=0; score[1]=0;
}

void menu(void)
{
 cls();
 center_string( 4,"MENU");
 center_string(10,"1. ONE PLAYER ");
 center_string(13,"2. TWO PLAYERS");
 game_option = choice_keypad(1,2);
}

void winner(void)
{
 cls();
 print_score();
 if (score[1]<score[0])
 { center_string(11,"PLAYER#1 WIN"); }
 if (score[0]<score[1])
 {
  if (game_option==1)
  { center_string(11,"COLECO WIN"); }
  else
  { center_string(11,"PLAYER#2 WIN"); }
 }
 if (score[0]==score[1])
 { center_string(11,"NO WINNER"); }
 pause();
}

void game(void)
{
 menu();
 init_game();
 game_loop();
 winner();
}